<?php
/*
# ------------------------------------------------------------------------
# Vina Product Carousel for VirtueMart for Joomla 3
# ------------------------------------------------------------------------
# Copyright(C) 2014 www.VinaGecko.com. All Rights Reserved.
# @license http://www.gnu.org/licenseses/gpl-3.0.html GNU/GPL
# Author: VinaGecko.com
# Websites: http://vinagecko.com
# Forum: http://vinagecko.com/forum/
# ------------------------------------------------------------------------
*/

// no direct access
defined('_JEXEC') or die('Restricted access');
JHtml::_('behavior.modal');
vmJsApi::jPrice();
$doc = JFactory::getDocument();

if(!defined('_OWL_CAROUSEL')) {
	$doc->addScript('modules/' . $module->module . '/assets/js/owl.carousel.min.js', 'text/javascript');
	$doc->addStyleSheet('modules/' . $module->module . '/assets/css/owl.carousel.min.css');
	$doc->addStyleSheet('modules/' . $module->module . '/assets/css/owl.theme.default.min.css');
	define('_OWL_CAROUSEL', 1);
}
if(!defined('_VINA_CAROUSEL_VIRTUEMART')){
	$doc->addStyleSheet('modules/' . $module->module . '/assets/css/custom.css');
	define('_VINA_CAROUSEL_VIRTUEMART', 1);
}
if(!defined('_VINA_COUNTDOWN')){
	define('_VINA_COUNTDOWN', 1);
	$doc->addScript(JURI::base() . 'templates/' . $template . '/js/jquery.countdown.min.js');
}
// Rating
$ratingModel = VmModel::getModel('ratings'); 
$ItemidStr = '';
$Itemid = shopFunctionsF::getLastVisitedItemId();
if(!empty($Itemid)){
	$ItemidStr = '&amp;Itemid='.$Itemid;
}

//Include Helix3 plugin
$helix3_path = JPATH_PLUGINS.'/system/helix3/core/helix3.php';

if (file_exists($helix3_path)) {
    require_once($helix3_path);
    $helix3 = helix3::getInstance();
} else {
    die('Please install and activate helix plugin');
}

$vm_product_labels 		=  $helix3->getParam('vm_product_labels', 1);
$newLabel_date 			=  $helix3->getParam('vm_product_label_newdate', 1);
$newLabel_limit 		=  $helix3->getParam('vm_product_label_newlimit', 1);
$vm_product_quickview 	=  $helix3->getParam('vm_product_quickview', 1);
$vm_product_desc_limit 	=  $helix3->getParam('vm_product_desc_limit', 60);

// Get New Products
$db    = JFactory::getDBO();
$query = "SELECT virtuemart_product_id FROM #__virtuemart_products WHERE DATE(product_available_date) >= DATE_SUB(CURDATE(), INTERVAL ". $newLabel_date." DAY) ORDER BY product_available_date DESC LIMIT 0, " . $newLabel_limit;
$db->setQuery($query);
$newIds = $db->loadColumn();

// Add styles
$styleModule 	 	= '';
$styleItem  	 	= '';
$styleItemLink 	 	= '';
$styleProductFields		= (!$productFields) ? 'display: none' : '';
$styleProductQuantity 	= (!$productQuantity) ? 'display: none' : '';
if($moduleConfig) {
	$styleModule .= 'width:' . $moduleWidth . ';';
	$styleModule .= 'height:' . $moduleHeight . ';';
	$styleModule .= 'margin:' . $moduleMargin. ';';
	$styleModule .= 'padding:' . $modulePadding . ';';
	$styleModule .= ($bgImage != '') ? "background-image: url({$bgImage});" : '';
	$styleModule .= ($isBgColor) ? "background-color: {$bgColor};" : '';
	
	
}
if($itemConfig) {
	$styleItem 		.= ($isItemBgColor) ? "background-color: {$itemBgColor};" : "";
	$styleItem 		.= 'margin:' . $itemMargin . ';';
	$styleItem 		.= 'padding:' .$itemPadding .';';
	$styleItem 		.= ($itemTextColor) ? "color: {$itemTextColor}" : '';
	$styleItemLink 	.= ($itemLinkColor) ? "color: {$itemLinkColor}" : '';
}
$style = '#vina-carousel-virtuemart'.$module->id .'{'
		. 'overflow: hidden;'
		. $styleModule . 
	'}' .
	'#vina-carousel-virtuemart'.$module->id .' .product-inner{'
		. 'overflow: hidden;'
		. $styleItem. 
	'}' . 	
	'#vina-carousel-virtuemart' .$module->id . ' .item product a {'
		. $styleItemLink. 
	'}'.	
	'#vina-carousel-virtuemart' .$module->id . ' .product-fields {'
		. $styleProductFields . 
	'}' .
	'#vina-carousel-virtuemart' .$module->id . ' .quantity-box,' .
	'#vina-carousel-virtuemart' .$module->id . ' .quantity-controls{'
		. $styleProductQuantity . 
	'}';	
$doc->addStyleDeclaration($style);
?>


<!-- HTML Block -->
<div id="vina-carousel-virtuemart<?php echo $module->id; ?>" class="vina-carousel-virtuemart owl-carousel owl-theme has-counter<?php echo $classSuffix; ?>">

		<?php
		$col 	= 1;
		$nb 	= 1;
		foreach ($products as $product) :
			$nb ++;
			$pImage 		= (!empty($product->images[0])) ? $product->images[0]->file_url : '';
			$pImage_second 	= (!empty($product->images[1])) ? $product->images[1]->file_url : '';
				
			$pName  	= $product->product_name;
			$sDesc  	= $product->product_s_desc;
			$pDesc  	= (!empty($sDesc)) ? shopFunctionsF::limitStringByWord($sDesc, $vm_product_desc_limit, ' ...') : '';
			$stock  	= $productModel->getStockIndicator($product);
			$sLevel 	= $stock->stock_level;
			$sTip   	= $stock->stock_tip;
			$pLink  	= JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $product->virtuemart_product_id . '&virtuemart_category_id=' . $product->virtuemart_category_id);
			$detail = JHTML::link($pLink, '<i class="fa fa-search"></i><span>'.vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS').'</span>', array('title' => vmText::_ ( 'COM_VIRTUEMART_PRODUCT_DETAILS' ), 'class' => 'product-details jutooltip'));
			$choose 	= JHTML::link($pLink, vmText::_('COM_VIRTUEMART_ADDTOCART_CHOOSE_VARIANT'), array('title' => vmText::_('COM_VIRTUEMART_ADDTOCART_CHOOSE_VARIANT'), 'class' => 'product-details'));
			$handle 	= shopFunctionsF::renderVmSubLayout('stockhandle', array('product' => $product));
			$pPrice 	= shopFunctionsF::renderVmSubLayout('prices', array('product' => $product, 'currency' => $currency));
			$sPrice 	= $currency->createPriceDiv('salesPrice', '', $product->prices, FALSE, FALSE, 1.0, TRUE);
			$dPrice 	= $currency->createPriceDiv('salesPriceWithDiscount', '', $product->prices, FALSE, FALSE, 1.0, TRUE);
			$pAddtocart 	= shopFunctionsF::renderVmSubLayout( 'addtocart', array('product' => $product) );
			if($resizeImage) {
				$pImage = modVinaCarouselVirtueMartHelper::resizeImage($resizeType, $pImage, 'thumb_', $imageWidth, $imageHeight, $module);		
				$pImage_second = modVinaCarouselVirtueMartHelper::resizeImage($resizeType, $pImage_second, 'thumb_', $imageWidth, $imageHeight, $module);		
			}
			$quickview = $pLink.'&amp;tmpl=component';
			$rating = shopFunctionsF::renderVmSubLayout('rating', array('showRating' => $productRating, 'product' => $product));
			
			// Timer
			$timer 		= $product->allPrices[0]["product_price_publish_down"];
			$new_timers = new DateTime($timer);
			$new_timer = $new_timers->format('Y/m/d');
	?>
	<?php if($col == 1) :?>
	<div class="item product">
		<?php endif; ?>
		<div class="product-inner">
				<?php 
				// Show Label Sale Or New		
				$isSaleLabel = (!empty($product->prices['discountAmount'])) ? 1 : 0;
				
				$pid = $product->virtuemart_product_id;
				$isNewLabel = in_array($pid, $newIds);
			?>
			<div class="item-i <?php echo ($m == 0) ? 'first' : '';?>">
				<!-- Image Block -->
				<?php if($productImage && !empty($pImage)) : ?>
				<div class="image-block vm-product-media-container">
					<!-- Check Product Label -->
					<?php if($vm_product_labels) {?>
					<div class="product-status">																						
						<?php if($isNewLabel && $isSaleLabel == 0) : ?>
							<div class="label-pro status-new"><span><?php echo JTEXT::_('VM_LANG_NEW'); ?></span></div>
						<?php endif; ?>
						<?php if($isNewLabel && $isSaleLabel != 0) : ?>
							<div class="label-pro status-new-sale"><span><?php echo JTEXT::_('VM_LANG_NEW'); ?></span></div>
						<?php endif; ?>
						<?php if($isSaleLabel != 0) : ?>
							<div class="label-pro status-sale"><span><?php echo JTEXT::_('VM_LANG_SALE'); ?></span></div>
						<?php endif; ?>
					</div>
					<?php } ?>
					<div class="image-block">
						<a href="<?php echo $pLink; ?>" title="<?php echo $pName; ?>">						
							<?php if(!empty($product->images[1])) :?>
								<div class="pro-image first-image">
									<img class="browseProductImage" src="<?php echo $pImage; ?>" alt="<?php echo $pName; ?>" title="<?php echo $pName; ?>" />
								</div>
								<div class="pro-image second-image">
									<img class="browseProductImage" src="<?php echo $pImage_second; ?>" alt="<?php echo $pName; ?>" title="<?php echo $pName; ?>" />				
								</div>			
							<?php else: ?>
								<div class="pro-image">
									<img class="browseProductImage" src="<?php echo $pImage; ?>" alt="<?php echo $pName; ?>" title="<?php echo $pName; ?>" />
								</div>
							<?php endif;?>						
						</a>
					</div>
				</div>
				<?php endif; ?>
				
				<!-- Text Block -->
				<div class="text-block">
				
					<!-- Timer -->
					<?php if( strtotime($new_timer) > strtotime('now') ) : ?>						
						<div class="timer-grid" data-countdown="<?php echo $new_timer;?>"></div>
					<?php endif;?>
					
					<!-- Product Name -->
					<?php if($productName) : ?>
						<h3 class="product-title"><a href="<?php echo $pLink; ?>" title="<?php echo $pName; ?>"><?php echo $pName; ?></a></h3>
					<?php endif; ?>					
					
					<!-- Product Stock -->
					<?php if($productStock) : ?>
					<div class="product-stock">
						<span class="vmicon vm2-<?php echo $sLevel; ?>" title="<?php echo $sTip; ?>"></span>
						<?php echo $handle; ?>
					</div>
					<?php endif; ?>									
					
					<!-- Product Rating -->
					<?php if($productRating) : ?>							
						<?php if ($ratingModel) { ?>
							<div class="vm-product-rating-container">
								<?php
								$maxrating = VmConfig::get('vm_maximum_rating_scale',5);
								$rating = $ratingModel->getRatingByProduct($product->virtuemart_product_id);
								$reviews = $ratingModel->getReviewsByProduct($product->virtuemart_product_id);
								if(empty($rating->rating)) { ?>						
									<div class="ratingbox dummy" title="<?php echo vmText::_('COM_VIRTUEMART_UNRATED'); ?>" >
									</div>
								<?php } else {						
									$ratingwidth = $rating->rating * 16; ?>
									<div title=" <?php echo (vmText::_("COM_VIRTUEMART_RATING_TITLE") . round($rating->rating) . '/' . $maxrating) ?>" class="ratingbox" >
									  <div class="stars-orange" style="width:<?php echo $ratingwidth.'px'; ?>"></div>
									</div>
								<?php } ?> 
								<?php if(!empty($reviews)) {					
									$count_review = 0;
									foreach($reviews as $k=>$review) {
										$count_review ++;
									}										
								?>
									<span class="amount">
										<a href="<?php echo $url; ?>" target="_blank" ><?php echo $count_review.' '.JText::_('VM_LANG_REVIEWS');?></a>
									</span>
								<?php } ?>								
							</div>
						<?php } ?>
					<?php endif; ?>
					
					<!-- Product Price -->
					<?php if($productPrice) : ?>					
					
						<?php if($isSaleLabel!= 0) : ?>							
							<?php echo $pPrice; ?>							
						<?php else : ?>
							<div class="product-price">
								<?php echo $sPrice; ?>
							</div>
						<?php endif; ?>
					
					<?php endif; ?>
					
					<!-- Product Description -->
					<?php if($productDesc && !empty($pDesc)) : ?>
					<div class="product-description"><?php echo $pDesc; ?></div>
					<?php endif; ?>
					
					<!-- Add to Cart Button & View Details Button -->
					<?php if($addtocart || $viewDetails) : ?>
						<div class="actions">
						
							<!-- Product Add To Cart -->
							<?php if($addtocart) : ?>
								<?php echo shopFunctionsF::renderVmSubLayout('addtocart',array('product'=>$product)); ?>
							<?php endif; ?>
							
							<!-- Product Add To Wishlist - View Details Button -->							
							<?php
								$detail_class = ' details-class';
								if(is_dir(JPATH_BASE."/components/com_wishlist/")) {
								$app = JFactory::getApplication();
								$detail_class ='';
							?>
								<!-- view Wishlist Button -->
								<div class="btn-wishlist">							
									<?php require(JPATH_BASE . "/templates/".$app->getTemplate()."/html/wishlist.php"); ?>													
								</div>						
							<?php } ?>							
							
							<!-- Quick View -->
							<?php if($viewDetails) : ?>									
								<div class="vm-details-button quick-view">
									<!-- <div class="vm-details-button<?php echo $detail_class;?>"><?php echo $detail; ?></div>-->
									<a href="<?php echo $quickview; ?>" class="vina-quickview modal jutooltip" title="<?php echo JText::_( 'VM_LANG_QUICK_VIEW' ); ?>">
										<i class="fa fa-search-plus"></i>
										<span><?php echo JText::_( 'VM_LANG_QUICK_VIEW' ); ?></span>
									</a>
								</div>
							<?php endif; ?>
						</div>
					<?php endif; ?>	
				</div>
			</div>	
		</div>
	<?php 
	if($col == $itemInCol || $nb > count($products)) { 
		$col = 1;
	echo '</div>';
	}else {
		$col ++;
	}
	endforeach; ?>
</div>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		
		/* Countdown */
		$('[data-countdown]').each(function() {
			var $this = $(this), 
			finalDate = $(this).data('countdown');
			$this.countdown(finalDate, function(event) {
				$this.html(event.strftime('<div class="day box-time-date"><span class="number">%D </span>Days</div> <div class="hour box-time-date"><span class="number">%H </span>Hrs</div><div class="min box-time-date"><span class="number"> %M</span> Mins</div> <div class="sec box-time-date"><span class="number">%S </span>Secs</div>'));
			});
		});
	}); 
</script>

<?php
//Javascript Block
$js =  '
	jQuery(document).ready(function($) {
		$("#vina-carousel-virtuemart' . $module->id . '").owlCarousel({'
			
			.'items : 				' . $items . ','
			.'startPosition:    	' . $startPosition . ','
			.'margin: 				' . $margin . ','
			.'stagePadding:			' . $stagePadding . ','
			.'loop: 				' . ($loop ? 'true' : 'false') . ','
			.'center: 				' . ($center ? 'true' : 'false') . ','
			.'rtl: 					' . (($doc->direction == 'rtl') ? 'true' : 'false') . ','
			.'slideBy: 				' . $slideBy . ','
			.'autoplay: 			' . $autoPlay . ','
			.'autoplayTimeout: 		' . $autoplayTimeout . ','
			.'autoplaySpeed: 		' . $autoplaySpeed . ','
			.'autoplayHoverPause: 	' . ($stopOnHover ? 'true' : 'false') . ','
			.'nav:					' . ($navigation ? 'true' : 'false') . ','
			.'navRewind:			' . ($rewindNav ? 'true' : 'false') . ','
			.'navText: 				[ "prev", "next" ],'
			.'navSpeed: 			' . $navigationSpeed . ','
			.'dots: 				' . ($pagination ? 'true' : 'false') . ','
			.'dotsSpeed: 			' . $paginationSpeed . ','
			.'autoWidth: 			' . ($autoWidth ? 'true' : 'false') . ','	
			.'autoHeight: 			' . ($autoHeight ? 'true' : 'false') . ','
			.'mouseDrag: 			' . ($mouseDrag ? 'true' : 'false') . ','
			.'touchDrag: 			' . ($touchDrag ? 'true' : 'false') . ',';
			if($responsive) {
			$js .= 'responsive:{'
				. '0:{'
					. 'items: ' . $itemsMobile . ',' // In this configuration 1 is enabled from 0px up to 479px screen size 
				.'},'
				.'480:{'
					.'items: ' . $itemsTabletSmall . ',' // from 480 to 767 
				.'},'
				.'768:{'
					.'items: ' . $itemsTablet . ',' // from this breakpoint 768 to 991
				.'},'
				.'992:{'
					.'items: ' . $itemsDesktopSmall . ',' // from this breakpoint 980 to 1199
				.'},'
				.'1200:{'
					.'items: ' . $itemsDesktop . ','
				.'}'
			.'}';
			}
			
		$js .= '});'
		
	.'});
';
$doc->addScriptdeclaration($js);
?>
