<?php
/**
 * ------------------------------------------------------------------------
 * JU Backend Toolkit for Joomla 2.5/3.x
 * ------------------------------------------------------------------------
 * Copyright (C) 2010-2013 JoomUltra. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: JoomUltra Co., Ltd
 * Websites: http://www.joomultra.com
 * ------------------------------------------------------------------------
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

if(!defined('DS')){
	define('DS', DIRECTORY_SEPARATOR);
}

jimport('joomla.form.formfield');

class JFormFieldJUFormStyle extends JFormField {

    protected $type = 'JUFormStyle';

	/**
	 * Method to get the field options.
	 *
	 * @return	array	The field option objects.
	 * @since	1.6
	 */
	protected function getLabel() {
		return '<div id="'.$this->id.'" style="display: none;"></div>';
	}
	
    protected function getInput() {
		//JHTML::_('behavior.mootools');
		//JHTML::_('behavior.framework');
		
		//Check if jQuery has been loaded
		$jQueryisLoaded = false;
		$document = JFactory::getDocument();
		$header = $document->getHeadData();
		$scripts = $header['scripts'];
		if(count($scripts)) {
			$pattern = '/([\/\\a-zA-Z0-9_:\.-]*)jquery([0-9\.-]|core|min|pack)*?.js/i';
			foreach ($scripts as $script => $opts) {
				if(preg_match($pattern, $script)) {
					$jQueryisLoaded = true;
					break;
				}
			}
		}
		
		//Detect base_path based on option type: module/plugin
		if(JRequest::getVar('option')=='com_plugins') {
			$base_path = JURI::root(true) . '/plugins/' . $this->form->getValue('folder') . '/' . $this->form->getValue('element');
		} else {
			$base_path = JURI::root(true) . '/modules/' . $this->form->getValue('module');
		}
		
		//Check J3.x
		$isJoomla3x = version_compare(JVERSION, '3.0', 'ge');

		//Add jQuery
		if(!$jQueryisLoaded) {
			if (!$isJoomla3x) {
				$document->addScript($base_path . '/admin/js/jquery.min.js');
			} else {
				JHtml::_('jquery.framework');
			}
		}
		//Add JU jQuery noConflict
		$document->addScript($base_path . '/admin/js/jquery-junoconflict.js');
		
		//jQuery UI
		//$document->addScript($base_path . '/admin/js/jquery.ui.core.min.js');//J2.5
		//JHtml::_('jquery.ui');//J3.0
		
		//jQuery easing
		//$document->addScript($base_path . '/admin/js/jquery.easing.1.3.min.js');
		
		//Get width/height for display: none; element
		$document->addScript($base_path . '/admin/js/chosen/jquery.actual.min.js');
		
		//Javascript/CSS for J2.5
		if (!$isJoomla3x) {
			//Chosen
			// Add chosen.jquery.js language strings
			JText::script('JGLOBAL_SELECT_SOME_OPTIONS');
			JText::script('JGLOBAL_SELECT_AN_OPTION');
			JText::script('JGLOBAL_SELECT_NO_RESULTS_MATCH');
			$document->addScript($base_path . '/admin/js/chosen/jquery.chosen.js');
			JFactory::getDocument()->addScriptDeclaration("
					try {
						JU_jQuery(document).ready(function ($){
							$('.form-validate select').chosen({
								disable_search_threshold : 10,
								allow_single_deselect : true
							}).change(function(){
								if(typeof(validate) == 'function') {
									validate();
								}
							});
						});
					} catch(e) {}
				"
			);
			$document->addStyleSheet($base_path . '/admin/js/chosen/chosen.css');
		} else {
			JHtml::_('formbehavior.chosen');
		}
		
		$addclass_js = "";
		if (!$isJoomla3x) {
			$fieldset_addclass_j25 = $this->element['fieldset_addclass_j25'];
			$fieldset_addclass_j25_arr = explode(",", $fieldset_addclass_j25);
			foreach ($fieldset_addclass_j25_arr AS $fieldset_itm) {
				$fieldset_arr = explode(":", $fieldset_itm);
				if($fieldset_itm) {
					$fieldset_number = trim($fieldset_arr[0]);
					$fieldset_class = trim($fieldset_arr[1]);
					$addclass_js .= "\t$('form[name=adminForm] div.panel').eq(".$fieldset_number.").find('h3.title').addClass('".$fieldset_class."');\n";
				}
			}
		} else {
			$fieldset_addclass_j3x = $this->element['fieldset_addclass_j3x'];
			$fieldset_addclass_j3x_arr = explode(",", $fieldset_addclass_j3x);
			foreach ($fieldset_addclass_j3x_arr AS $fieldset_itm) {
				$fieldset_arr = explode(":", $fieldset_itm);
				if($fieldset_itm) {
					$fieldset_number = trim($fieldset_arr[0]);
					$fieldset_class = trim($fieldset_arr[1]);
					$addclass_js .= "\t$('form[name=adminForm] ul.nav-tabs li').eq(".$fieldset_number.").addClass('".$fieldset_class."');\n";
				}
			}
		}
		
		//Add class for fieldsets
		JFactory::getDocument()->addScriptDeclaration("JU_jQuery(document).ready(function ($){\n".$addclass_js."});\n");
		
		//Radio Group
		$document->addScript($base_path . '/admin/js/radio-group.min.js');
		
		//Color picker
		$document->addScript($base_path . '/admin/js/colorpicker/colorpicker.js');
		$document->addScript($base_path . '/admin/js/colorpicker.min.js');
		$document->addStyleSheet($base_path . '/admin/js/colorpicker/colorpicker.css');
		
		//JU Filter
        $document->addScript($base_path . '/admin/js/jufilter.min.js');
		
		//JU Group
        $document->addScript($base_path . '/admin/js/jugroup.min.js');
		
		//Custom Javascript
        $document->addScript($base_path . '/admin/js/javascript.js');

		//Custom CSS
		if (!$isJoomla3x) {
			$document->addStyleSheet($base_path . '/admin/css/styles.css');
		} else {
			$document->addStyleSheet($base_path . '/admin/css/styles_j3.css');
		}
		
		$document->addStyleSheet($base_path . '/admin/css/fieldstyle.css');
        
		//Auto remove the field itself
		$document->addScriptDeclaration("JU_jQuery(document).ready(function(\$){\$('#".$this->id."').parent().remove();});");
		
        return false;
    }
}
?>