<?php
/*
# ------------------------------------------------------------------------
# Vina Manufacturers Carousel for VirtueMart for Joomla 3
# ------------------------------------------------------------------------
# Copyright(C) 2016 www.VinaGecko.com. All Rights Reserved.
# @license http://www.gnu.org/licenseses/gpl-3.0.html GNU/GPL
# Author: VinaGecko.com
# Websites: http://vinagecko.com
# Forum:    http://vinagecko.com/forum/
# ------------------------------------------------------------------------
*/

defined('_JEXEC') or die('Restricted access');

// VirtueMart config
if(!class_exists('VmConfig')) {
	require(JPATH_ROOT . '/administrator/components/com_virtuemart/helpers/config.php');
}

VmConfig::loadConfig();
VmConfig::loadJLang($module->module, true);

require_once dirname(__FILE__) . '/helper.php';

$model 			= VmModel::getModel('Manufacturer');
$manufacturers 	= $model->getManufacturers(true, true, true);
$model->addImages($manufacturers);
if(empty($manufacturers)) return false;

// Source setting
$showImage 		= $params->get('showImage', 		1);
$showName		= $params->get('showName', 			1);
$resizeImage 	= (bool)$params->get('resizeImage', 1);
$resizeType		= $params->get('resizeType', 		1);
$imageWidth 	= $params->get('imageWidth', 		200);
$imageHeight 	= $params->get('imageHeight', 		130);
$linkOnImage	= $params->get('linkOnImage',		0);
$linkOnName		= $params->get('linkOnName', 		1);

// module setting
$classSuffix 	= $params->get('moduleclass_sfx', 	'');
$moduleConfig 	= $params->get('moduleConfig', 		1);
$moduleWidth	= $params->get('moduleWidth', 		'100%');
$moduleHeight	= $params->get('moduleHeight', 		'auto');
$moduleMargin	= $params->get('moduleMargin', 		'0px');
$modulePadding	= $params->get('modulePadding', 	'0px');
$bgImage		= $params->get('bgImage', 			null);
if($bgImage != '') {
	if(strpos($bgImage, 'http://') === FALSE) {
		$bgImage = JURI::base() . $bgImage;
	}
}
$isBgColor		= $params->get('isBgColor', 		1);
$bgColor		= $params->get('bgColor', 			'#cccccc');

$itemConfig 	= $params->get('itemConfig', 		1);
$itemMargin		= $params->get('itemMargin', 		'15px 0px');
$itemPadding	= $params->get('itemPadding', 		'10px');
$isItemBgColor	= $params->get('isItemBgColor', 	1);
$itemBgColor	= $params->get('itemBgColor', 		'#FFFFFF');
$captionBgColor	= $params->get('captionBgColor', 	null);
$captionColor	= $params->get('captionColor', 		null);


// Carousel Params
$items				= $params->get('items', 			4);
$itemInCol			= $params->get('itemInCol', 		1);
$responsive			= $params->get('responsive', 		1);
$itemsDesktop		= $params->get('itemsDesktop', 		4);
$itemsDesktopSmall	= $params->get('itemsDesktopSmall', 3);
$itemsTabletSmall	= $params->get('itemsTabletSmall', 	2);
$itemsTablet		= $params->get('itemsTablet', 		2);
$itemsMobile		= $params->get('itemsMobile', 		1);
$startPosition		= $params->get('startPosition', 	0);
$margin				= $params->get('margin', 			15);
$stagePadding		= $params->get('stagePadding', 		15);
$loop				= $params->get('loop', 				0);
$center				= $params->get('center', 			0);
$slideBy			= $params->get('slideBy', 			1);
$autoPlay			= $params->get('autoPlay', 			1);
$autoplayTimeout	= $params->get('autoplayTimeout', 	5000);
$autoplaySpeed		= $params->get('autoplaySpeed', 	800);
$stopOnHover		= $params->get('stopOnHover', 		1);
$navigation			= $params->get('navigation', 		1);
$rewindNav			= $params->get('rewindNav', 		1);
$navigationSpeed	= $params->get('navigationSpeed', 	800);
$pagination			= $params->get('pagination', 		0);
$paginationSpeed	= $params->get('paginationSpeed',   800);
$autoHeight			= $params->get('autoHeight', 		0);
$autoWidth			= $params->get('autoWidth', 		0);
$mouseDrag			= $params->get('mouseDrag', 		1);
$touchDrag			= $params->get('touchDrag', 		1);

require(JModuleHelper::getLayoutPath($module->module, 'default'));