<?php
/*
# ------------------------------------------------------------------------
# Vina Product Carousel for VirtueMart for Joomla 3
# ------------------------------------------------------------------------
# Copyright(C) 2016 www.VinaGecko.com. All Rights Reserved.
# @license http://www.gnu.org/licenseses/gpl-3.0.html GNU/GPL
# Author: VinaGecko.com
# Websites: http://vinagecko.com
# Forum: http://vinagecko.com/forum/
# ------------------------------------------------------------------------
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class modVinaManufacturersVirtueMartHelper
{
	public static function resizeImage($type, $file, $prefix, $width, $height, $module)
	{
		jimport('joomla.filesystem.folder');
		jimport('joomla.filesystem.file');
		
		// Set noimage if the image isn't exists
		if(!JFile::exists($file)) {
			$file = "modules/". $module->module ."/assets/images/noimage.jpg";
		}
		
		// Check if new image is exists
		$newFile = "cache/". $module->module ."/" . $module->id . "/" . date("Y") ."/". $prefix . basename($file);
		if(JFile::exists($newFile)) {
			return JURI::base() . $newFile;
		}
		else {
			JFolder::create(dirname($newFile));
		}
		
		// Instantiate our JImage object
		$image 			= new JImage($file);
		$resizedImage 	= $image->resize($width, $height, true, $type);
		
		$properties 	= JImage::getImageFileProperties($file);
		$mime 			= $properties->mime;
		
		if($mime == 'image/jpeg') {
			$type = IMAGETYPE_JPEG;
		}
		elseif($mime = 'image/png') {
			$type = IMAGETYPE_PNG;
		}
		elseif($mime = 'image/gif') {
			$type = IMAGETYPE_GIF;
		}
		
		// Store the resized image to a new file
		$resizedImage->toFile($newFile, $type);
		
		return JURI::base() . $newFile;
	}
}