<?php
/*
# ------------------------------------------------------------------------
# Vina Product Carousel for VirtueMart for Joomla 3
# ------------------------------------------------------------------------
# Copyright(C) 2016 www.VinaGecko.com. All Rights Reserved.
# @license http://www.gnu.org/licenseses/gpl-3.0.html GNU/GPL
# Author: VinaGecko.com
# Websites: http://vinagecko.com
# Forum: http://vinagecko.com/forum/
# ------------------------------------------------------------------------
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

vmJsApi::jPrice();
$doc = JFactory::getDocument();

if(!defined('_OWL_CAROUSEL')) {
	$doc->addScript('modules/' . $module->module . '/assets/js/owl.carousel.min.js', 'text/javascript');
	$doc->addStyleSheet('modules/' . $module->module . '/assets/css/owl.carousel.min.css');
	$doc->addStyleSheet('modules/' . $module->module . '/assets/css/owl.theme.default.min.css');
	define('_OWL_CAROUSEL', 1);
}
if(!defined('_VINA_CAROUSEL_VIRTUEMART')){
	$doc->addStyleSheet('modules/' . $module->module . '/assets/css/custom.css');
	define('_VINA_CAROUSEL_VIRTUEMART', 1);
}

// Add styles
$styleModule 	 	= '';
$styleItem  	 	= '';
$styleItemLink 	 	= '';
$styleProductFields		= (!$productFields) ? 'display: none' : '';
$styleProductQuantity 	= (!$productQuantity) ? 'display: none' : '';
if($moduleConfig) {
	$styleModule .= 'width:' . $moduleWidth . ';';
	$styleModule .= 'height:' . $moduleHeight . ';';
	$styleModule .= 'margin:' . $moduleMargin. ';';
	$styleModule .= 'padding:' . $modulePadding . ';';
	$styleModule .= ($bgImage != '') ? "background-image: url({$bgImage});" : '';
	$styleModule .= ($isBgColor) ? "background-color: {$bgColor};" : '';
	
	
}
if($itemConfig) {
	$styleItem 		.= ($isItemBgColor) ? "background-color: {$itemBgColor};" : "";
	$styleItem 		.= 'margin:' . $itemMargin . ';';
	$styleItem 		.= 'padding:' .$itemPadding .';';
	$styleItem 		.= ($itemTextColor) ? "color: {$itemTextColor}" : '';
	$styleItemLink 	.= ($itemLinkColor) ? "color: {$itemLinkColor}" : '';
}
$style = '#vina-carousel-virtuemart'.$module->id .'{'
		. 'overflow: hidden;'
		. $styleModule . 
	'}' .
	'#vina-carousel-virtuemart'.$module->id .' .item-i{'
		. 'overflow: hidden;'
		. $styleItem. 
	'}' . 	
	'#vina-carousel-virtuemart' .$module->id . ' .item-i a {'
		. $styleItemLink. 
	'}'.	
	'#vina-carousel-virtuemart' .$module->id . ' .product-fields {'
		. $styleProductFields . 
	'}' .
	'#vina-carousel-virtuemart' .$module->id . ' .quantity-box,' .
	'#vina-carousel-virtuemart' .$module->id . ' .quantity-controls{'
		. $styleProductQuantity . 
	'}';	
$doc->addStyleDeclaration($style);
?>

<!-- HTML Block -->
<div id="vina-carousel-virtuemart<?php echo $module->id; ?>" class="vina-carousel-virtuemart owl-carousel owl-theme <?php echo $classSuffix; ?>">
	<?php
		$col 	= 1;
		$nb 	= 1;
		foreach ($products as $product) :
			$nb ++;
			$pImage 	= (!empty($product->images[0])) ? $product->images[0]->file_url : '';
			$pName  	= $product->product_name;
			$sDesc  	= $product->product_s_desc;
			$pDesc  	= (!empty($sDesc)) ? shopFunctionsF::limitStringByWord($sDesc, 60, ' ...') : '';
			$stock  	= $productModel->getStockIndicator($product);
			$sLevel 	= $stock->stock_level;
			$sTip   	= $stock->stock_tip;
			$pLink  	= JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $product->virtuemart_product_id . '&virtuemart_category_id=' . $product->virtuemart_category_id);
			$detail 	= JHTML::link($pLink, vmText::_('COM_VIRTUEMART_PRODUCT_DETAILS'), array('title' => $pName, 'class' => 'product-details'));
			$choose 	= JHTML::link($pLink, vmText::_('COM_VIRTUEMART_ADDTOCART_CHOOSE_VARIANT'), array('title' => vmText::_('COM_VIRTUEMART_ADDTOCART_CHOOSE_VARIANT'), 'class' => 'product-details'));
			$handle 	= shopFunctionsF::renderVmSubLayout('stockhandle', array('product' => $product));
			$pPrice 	= shopFunctionsF::renderVmSubLayout('prices', array('product' => $product, 'currency' => $currency));
			$sPrice 	= $currency->createPriceDiv('salesPrice', '', $product->prices, FALSE, FALSE, 1.0, TRUE);
			$dPrice 	= $currency->createPriceDiv('salesPriceWithDiscount', '', $product->prices, FALSE, FALSE, 1.0, TRUE);
			$pAddtocart 	= shopFunctionsF::renderVmSubLayout( 'addtocart', array('product' => $product) );
			if($resizeImage) {
				$pImage = modVinaCarouselVirtueMartHelper::resizeImage($resizeType, $pImage, 'thumb_', $imageWidth, $imageHeight, $module);		
			}
	?>
	<?php if($col == 1) :?>
	<div class="item">
	<?php endif; ?>
		<div class="item-i round-corners">
		<div class="product-container">
			<!-- Image Block -->
			<?php if($productImage && !empty($pImage)) : ?>
			<div class="image-block">
				<a href="<?php echo $pLink; ?>" title="<?php echo $pName; ?>">
					<img src="<?php echo $pImage; ?>" alt="<?php echo $pName; ?>" title="<?php echo $pName; ?>" />
				</a>
			</div>
			<?php endif; ?>
			
			<!-- Text Block -->
			<div class="text-block productdetails">
				<!-- Product Rating -->
				<?php if($productRating && $ratingModel) : ?>
					<div class="vm-product-rating-container">
						<?php
						$maxrating = VmConfig::get('vm_maximum_rating_scale',5);
						$rating = $ratingModel->getRatingByProduct($product->virtuemart_product_id);
						if(empty($rating->rating)) { ?>						
							<div class="ratingbox dummy" title="<?php echo vmText::_('COM_VIRTUEMART_UNRATED'); ?>" ></div><?php 
						} else {						
							$ratingwidth = $rating->rating * 24; ?>
							<div title=" <?php echo (vmText::_("COM_VIRTUEMART_RATING_TITLE") . round($rating->rating) . '/' . $maxrating) ?>" class="ratingbox" >
							  <div class="stars-orange" style="width:<?php echo $ratingwidth.'px'; ?>"></div>
							</div><?php 
						} ?>								
					</div>
				<?php endif; ?>
				
				<!-- Product Stock -->
				<?php if($productStock) : ?>
				<div class="product-stock">
					<span class="vmicon vm2-<?php echo $sLevel; ?>" title="<?php echo $sTip; ?>"></span>
					<?php echo $handle; ?>
				</div>
				<?php endif; ?>
				
				<!-- Product Name -->
				<?php if($productName) : ?>
				<h3 class="product-title"><a href="<?php echo $pLink; ?>" title="<?php echo $pName; ?>"><?php echo $pName; ?></a></h3>
				<?php endif; ?>
				
				<!-- Product Description -->
				<?php if($productDesc && !empty($pDesc)) : ?>
				<div class="product-description"><?php echo $pDesc; ?></div>
				<?php endif; ?>
				
				<!-- Product Price -->
				<?php if($productPrice) : ?>
				<div class="product-price">
					<?php if(!empty($product->prices['salesPrice'])) echo $sPrice; ?>
					<?php if(!empty($product->prices['salesPriceWithDiscount'])) echo $dPrice; ?>
				</div>
				<?php endif; ?>
				
				<!-- Add to Cart Button & View Details Button -->
				<?php if($addtocart || $viewDetails) : ?>
				<div class="button-group">
					<!-- Product Add To Cart -->
					<?php if($addtocart) : ?>
					<div class="addtocart">
					<?php
						if($chooseVariant && !$product->orderable) {
							echo $choose;
						} else {
							echo $pAddtocart;
						}
					?>
					</div>
					<?php endif; ?>
					
					<!-- View Details Button -->
					<?php if($viewDetails) : ?>
					<div class="vm-details-button"><?php echo $detail; ?></div>
					<?php endif; ?>
				</div>
				<?php endif; ?>
			</div>
		</div>
		</div>
	<?php 
	if($col == $itemInCol || $nb > count($products)) { 
		$col = 1;
	echo '</div>';
	}else {
		$col ++;
	}
	endforeach; ?>
</div>

<?php
//Javascript Block
$js =  '
	jQuery(document).ready(function($) {
		$("#vina-carousel-virtuemart' . $module->id . '").owlCarousel({'
			
			.'items : 				' . $items . ','
			.'startPosition:    	' . $startPosition . ','
			.'margin: 				' . $margin . ','
			.'stagePadding:			' . $stagePadding . ','
			.'loop: 				' . ($loop ? 'true' : 'false') . ','
			.'center: 				' . ($center ? 'true' : 'false') . ','
			.'rtl: 					' . (($doc->direction == 'rtl') ? 'true' : 'false') . ','
			.'slideBy: 				' . $slideBy . ','
			.'autoplay: 			' . $autoPlay . ','
			.'autoplayTimeout: 		' . $autoplayTimeout . ','
			.'autoplaySpeed: 		' . $autoplaySpeed . ','
			.'autoplayHoverPause: 	' . ($stopOnHover ? 'true' : 'false') . ','
			.'nav:					' . ($navigation ? 'true' : 'false') . ','
			.'navRewind:			' . ($rewindNav ? 'true' : 'false') . ','
			.'navText: 				[ "prev", "next" ],'
			.'navSpeed: 			' . $navigationSpeed . ','
			.'dots: 				' . ($pagination ? 'true' : 'false') . ','
			.'dotsSpeed: 			' . $paginationSpeed . ','
			.'autoWidth: 			' . ($autoWidth ? 'true' : 'false') . ','	
			.'autoHeight: 			' . ($autoHeight ? 'true' : 'false') . ','
			.'mouseDrag: 			' . ($mouseDrag ? 'true' : 'false') . ','
			.'touchDrag: 			' . ($touchDrag ? 'true' : 'false') . ',';
			if($responsive) {
			$js .= 'responsive:{'
				. '0:{'
					. 'items: ' . $itemsMobile . ',' // In this configuration 1 is enabled from 0px up to 479px screen size 
				.'},'
				.'480:{'
					.'items: ' . $itemsTabletSmall . ',' // from 480 to 767 
				.'},'
				.'768:{'
					.'items: ' . $itemsTablet . ',' // from this breakpoint 768 to 991
				.'},'
				.'992:{'
					.'items: ' . $itemsDesktopSmall . ',' // from this breakpoint 980 to 1199
				.'},'
				.'1200:{'
					.'items: ' . $itemsDesktop . ','
				.'}'
			.'}';
			}
			
		$js .= '});'
	.'});
';
$doc->addScriptdeclaration($js);