<?php
/*
# ------------------------------------------------------------------------
# Vina Product Carousel for VirtueMart for Joomla 3
# ------------------------------------------------------------------------
# Copyright(C) 2016 www.VinaGecko.com. All Rights Reserved.
# @license http://www.gnu.org/licenseses/gpl-3.0.html GNU/GPL
# Author: VinaGecko.com
# Websites: http://vinagecko.com
# Forum: http://vinagecko.com/forum/
# ------------------------------------------------------------------------
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

/* VirtueMart config */
defined('DS') or define('DS', DIRECTORY_SEPARATOR);

if(!class_exists('VmConfig')) {
	require(JPATH_ROOT . '/administrator/components/com_virtuemart/helpers/config.php');
}

VmConfig::loadConfig();
VmConfig::loadJLang($module->module, true);

require_once dirname(__FILE__) . '/helper.php';

// Source setting
$moduleType 	= $params->get('moduleType', 			'featured');
$filterCategory = (bool)$params->get('filterCategory', 	0);
$categoryId 	= $params->get('categoryId', 			null);
$maxItems 		= $params->get('maxItems', 				10);
$productName 	= (bool)$params->get('productName', 	1);
$productImage 	= (bool)$params->get('productImage', 	1);
$resizeImage 	= (bool)$params->get('resizeImage', 	1);
$resizeType		= $params->get('resizeType', 			1);
$imageWidth 	= $params->get('imageWidth', 			200);
$imageHeight 	= $params->get('imageHeight', 			150);
$productRating 	= (bool)$params->get('productRating', 	1);
$productStock 	= (bool)$params->get('productStock', 	1);
$productDesc 	= (bool)$params->get('productDesc', 	1);
$productPrice 	= (bool)$params->get('productPrice', 	1);
$addtocart 		= (bool)$params->get('addtocart', 		1);
$productFields 	= (bool)$params->get('productFields', 	1);
$productQuantity = (bool)$params->get('productQuantity',1);
$chooseVariant	= (bool)$params->get('chooseVariant', 	0);
$viewDetails 	= (bool)$params->get('viewDetails', 	1);

$mainframe   = JFactory::getApplication();
$vCurrencyId = $mainframe->getUserStateFromRequest("virtuemart_currency_id", 'virtuemart_currency_id', vRequest::getInt('virtuemart_currency_id', 0));

vmJsApi::jPrice();
vmJsApi::cssSite();

$vendorId 		= vRequest::getInt('vendorid', 1);
$productModel 	= VmModel::getModel('Product');
$ratingModel = VmModel::getModel('ratings');

$products = $productModel->getProductListing($moduleType, $maxItems, $productPrice, true, false, $filterCategory, $categoryId);
$productModel->addImages($products);

if (!class_exists('shopFunctionsF'))
	require(JPATH_VM_SITE . '/helpers/shopfunctionsf.php');
shopFunctionsF::sortLoadProductCustomsStockInd($products,$productModel);

if(empty($products)) return false;
if (!class_exists('CurrencyDisplay'))
	require(VMPATH_ADMIN . '/helpers/currencydisplay.php');
$currency = CurrencyDisplay::getInstance();


// module setting
$classSuffix 	= $params->get('moduleclass_sfx', 	'');
$moduleConfig 	= $params->get('moduleConfig', 		1);
$moduleWidth	= $params->get('moduleWidth', 		'100%');
$moduleHeight	= $params->get('moduleHeight', 		'auto');
$moduleMargin	= $params->get('moduleMargin', 		'0px');
$modulePadding	= $params->get('modulePadding', 	'0px');
$bgImage		= $params->get('bgImage', 			null);
if($bgImage != '') {
	if(strpos($bgImage, 'http://') === FALSE) {
		$bgImage = JURI::base() . $bgImage;
	}
}
$isBgColor		= $params->get('isBgColor', 	1);
$bgColor		= $params->get('bgColor',		'#CCCCCC');

$itemConfig 	= $params->get('itemConfig', 	1);
$itemMargin		= $params->get('itemMargin',	'15px 0');
$itemPadding	= $params->get('itemPadding', 	'10px');
$isItemBgColor	= $params->get('isItemBgColor', 1);
$itemBgColor	= $params->get('itemBgColor',	'#FFFFFF');
$itemTextColor	= $params->get('itemTextColor',	null);
$itemLinkColor	= $params->get('itemLinkColor', null);

// Carousel Params
$items				= $params->get('items', 			4);
$itemInCol			= $params->get('itemInCol', 		1);
$responsive			= $params->get('responsive', 		1);
$itemsDesktop		= $params->get('itemsDesktop', 		4);
$itemsDesktopSmall	= $params->get('itemsDesktopSmall', 3);
$itemsTabletSmall	= $params->get('itemsTabletSmall', 	2);
$itemsTablet		= $params->get('itemsTablet', 		2);
$itemsMobile		= $params->get('itemsMobile', 		1);
$startPosition		= $params->get('startPosition', 	0);
$margin				= $params->get('margin', 			15);
$stagePadding		= $params->get('stagePadding', 		15);
$loop				= $params->get('loop', 				0);
$center				= $params->get('center', 			0);
$slideBy			= $params->get('slideBy', 			1);
$autoPlay			= $params->get('autoPlay', 			1);
$autoplayTimeout	= $params->get('autoplayTimeout', 	5000);
$autoplaySpeed		= $params->get('autoplaySpeed', 	800);
$stopOnHover		= $params->get('stopOnHover', 		1);
$navigation			= $params->get('navigation', 		1);
$rewindNav			= $params->get('rewindNav', 		1);
$navigationSpeed	= $params->get('navigationSpeed', 	800);
$pagination			= $params->get('pagination', 		0);
$paginationSpeed	= $params->get('paginationSpeed',   800);
$autoHeight			= $params->get('autoHeight', 		0);
$autoWidth			= $params->get('autoWidth', 		0);
$mouseDrag			= $params->get('mouseDrag', 		1);
$touchDrag			= $params->get('touchDrag', 		1);

// include layout
require(JModuleHelper::getLayoutPath($module->module, $params->get('layout', 'default')));

echo vmJsApi::writeJS();